/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.enderchestmod.client;

import io.redspace.enderchestmod.blocks.copper_ender_chest.CopperEnderChestEntity;
import io.redspace.enderchestmod.blocks.diamond_ender_chest.DiamondEnderChestEntity;
import io.redspace.enderchestmod.blocks.emerald_ender_chest.EmeraldEnderChestEntity;
import io.redspace.enderchestmod.blocks.gold_ender_chest.GoldEnderChestEntity;
import io.redspace.enderchestmod.blocks.iron_ender_chest.IronEnderChestEntity;
import io.redspace.enderchestmod.blocks.lapis_ender_chest.LapisEnderChestEntity;
import io.redspace.enderchestmod.blocks.netherite_ender_chest.NetheriteEnderChestEntity;
import io.redspace.enderchestmod.blocks.redstone_ender_chest.RedstoneEnderChestEntity;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iron_ender_chests", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TieredEnderChestRenderer
extends ChestRenderer {
    public static final Material NETHERITE_LOCATION = TieredEnderChestRenderer.chestMaterial("netherite");
    public static final Material DIAMOND_LOCATION = TieredEnderChestRenderer.chestMaterial("diamond");
    public static final Material IRON_LOCATION = TieredEnderChestRenderer.chestMaterial("iron");
    public static final Material COPPER_LOCATION = TieredEnderChestRenderer.chestMaterial("copper");
    public static final Material GOLD_LOCATION = TieredEnderChestRenderer.chestMaterial("gold");
    public static final Material REDSTONE_LOCATION = TieredEnderChestRenderer.chestMaterial("redstone");
    public static final Material LAPIS_LOCATION = TieredEnderChestRenderer.chestMaterial("lapis");
    public static final Material EMERALD_LOCATION = TieredEnderChestRenderer.chestMaterial("emerald");

    public TieredEnderChestRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
    }

    protected Material getMaterial(BlockEntity blockEntity, ChestType chestType) {
        if (blockEntity instanceof IronEnderChestEntity) {
            return IRON_LOCATION;
        }
        if (blockEntity instanceof CopperEnderChestEntity) {
            return COPPER_LOCATION;
        }
        if (blockEntity instanceof DiamondEnderChestEntity) {
            return DIAMOND_LOCATION;
        }
        if (blockEntity instanceof NetheriteEnderChestEntity) {
            return NETHERITE_LOCATION;
        }
        if (blockEntity instanceof GoldEnderChestEntity) {
            return GOLD_LOCATION;
        }
        if (blockEntity instanceof LapisEnderChestEntity) {
            return LAPIS_LOCATION;
        }
        if (blockEntity instanceof RedstoneEnderChestEntity) {
            return REDSTONE_LOCATION;
        }
        if (blockEntity instanceof EmeraldEnderChestEntity) {
            return EMERALD_LOCATION;
        }
        return Sheets.f_110754_;
    }

    private static Material chestMaterial(String pChestName) {
        return new Material(Sheets.f_110740_, new ResourceLocation("iron_ender_chests", "entity/chest/" + pChestName));
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
            return;
        }
        event.addSprite(NETHERITE_LOCATION.m_119203_());
        event.addSprite(DIAMOND_LOCATION.m_119203_());
        event.addSprite(IRON_LOCATION.m_119203_());
        event.addSprite(COPPER_LOCATION.m_119203_());
        event.addSprite(GOLD_LOCATION.m_119203_());
        event.addSprite(REDSTONE_LOCATION.m_119203_());
        event.addSprite(LAPIS_LOCATION.m_119203_());
        event.addSprite(EMERALD_LOCATION.m_119203_());
    }
}

